#!/usr/bin/awk -f
# All possible files generated by gws
BEGIN{if(!(bin||other||sh||shconf||web)){bin=1;other=1;sh=1;shconf=1;web=1}}
/^\/etc\/comtrade(ssh)?\.conf$/                        && other  # script conf (read line)
/^\/etc\/comtrade_id$/                                 && other  # ssh identity
/^\/etc\/crontab$/                                     && other  # executes commands
/^\/etc\/default\/comtraded$/                          && shconf # sourced conf
/^\/etc\/default\/ntpd$/                               && shconf # sourced conf
/^\/etc\/default\/snmpd$/                              && shconf # sourced conf
/^\/etc\/default\/syslogd$/                            && shconf # sourced conf
/^\/etc\/dns\.conf$/                                   && other  #
/^\/etc\/gwpinger\.conf$/                              && other  # script conf (read line)
/^\/etc\/hostname$/                                    && other  #
/^\/etc\/hosts$/                                       && other  #
/^\/etc\/init\.d\/network_eth[1-5]$/                   && sh     # script /bin/sh
/^\/etc\/init\.d\/S39iptables$/                        && sh     # script /bin/sh
/^\/etc\/init\.d\/S40network$/                         && sh     # script /bin/sh
/^\/etc\/ipsec-tools\.conf$/                           && other  # script /usr/sbin/setkey -f
/^\/etc\/l2tp\/dialer\.conf$/                          && other  # script conf (read line)
/^\/etc\/l2tp\/l2tp-secrets$/                          && other  #
/^\/etc\/l2tp\/ppp[0-9xX]+_options$/                   && other  #
/^\/etc\/l2tp\/xl2tpd\.conf$/                          && other  #
/^\/etc\/ntp\.conf$/                                   && other  #
/^\/etc\/openvpn\/client[0-9]*\.conf$/                 && other  #
/^\/etc\/openvpn\/tun[0-9]+\/(client|ca)\.crt$/        && other  #
/^\/etc\/openvpn\/tun[0-9]+\/(client|t)\.key$/         && other  #
/^\/etc\/ppp\/chap-secrets(-cdma)?$/                   && other  #
/^\/etc\/ppp\/l2tp-ip-(down|up)$/                      && sh     # script /bin/sh
/^\/etc\/ppp\/options$/                                && other  #
/^\/etc\/ppp\/pap-secrets$/                            && other  #
/^\/etc\/ppp\/peers\/(cdma|modem)_chat$/               && other  # legacy
/^\/etc\/ppp\/peers\/(VMX53\/)?sim[12]_chat$/          && other  # legacy
/^\/etc\/ppp\/peers\/sim[12]\.conf$/                   && shconf # sourced conf
/^\/etc\/ppp\/resolv\.conf$/                           && other  #
/^\/etc\/ppp\/serial[0-9]+\.conf$/                     && shconf # sourced conf
/^\/etc\/racoon\/ipsec-ip-(down|up)$/                  && sh     # script /bin/sh
/^\/etc\/racoon\/psk\.txt$/                            && other  #
/^\/etc\/racoon\/racoon\.conf$/                        && other  #
/^\/etc\/resolv\.conf$/                                && other  #
/^\/etc\/snmp\/snmpd\.conf$/                           && other  #
/^\/etc\/(ssh\/)?sshd?_config$/                        && other  #
/^\/etc\/ssl\/certs\/([0-9]+_)?web_server_cert\.pem$/  && other  #
/^\/etc\/ssl\/private\/([0-9]+_)?web_server_key\.pem$/ && other  #
/^\/etc\/telem-gps\.conf$/                             && shconf # sourced conf
/^\/etc\/terminals\/terminal-[0-9]+\.conf$/            && shconf # sourced conf
/^\/etc\/TZ$/                                          && other  #
/^\/etc\/update\.conf$/                                && shconf # sourced conf
/^\/home\/martem\/\.ssh\/authorized_keys$/             && other  #
/^\/usr\/local\/etc\/telem\/gwSetup.bin$/              && bin    # telem conf
/^\/usr\/local\/etc\/telem\/log-conf\.xml$/            && other  # telem conf
/^\/usr\/local\/etc\/telem\/setup\.xml$/               && other  # telem conf
# website
/^\/var\/www-[0-9]+\/.*/                               && web    #
