#!/usr/bin/awk -f
# Allow root to execute only [/root/*] and [su martem -c '*']
BEGIN{RS = "\r\n|\n"}
# comments
/^\s*#/ {print; next}
# space
/^\s*$/ {print; next}
# minutes:  1,2-10,20-30/2,44
$1!~/^[0-9*,\/-]{1,32}$/ {if(bad) print > bad; next}
$1!~/^(([*]|([0-5]?[0-9]([-][0-5]?[0-9])?))(\/[1-9][0-9]?)?)(,([*]|([0-5]?[0-9]([-][0-5]?[0-9])?))(\/[1-9][0-9]?)?)*$/ {if(bad) print > bad; next}
# hour:  1,2-10,11-20/2,23
$2!~/^[0-9*,\/-]{1,32}$/ {if(bad) print > bad; next}
$2!~/^(([*]|(([01]?[0-9]|2[0-3])([-]([01]?[0-9]|2[0-3]))?))(\/[1-9][0-9]?)?)(,([*]|(([01]?[0-9]|2[0-3])([-]([01]?[0-9]|2[0-3]))?))(\/[1-9][0-9]?)?)*$/ {if(bad) print > bad; next}
# day of month: 5-10/2,20
$3!~/^[0-9*,\/-]{1,32}$/ {if(bad) print > bad; next}
$3!~/^(([*]|([0-2]?[0-9]|3[0-1])([-]([0-2]?[0-9]|3[0-1]))?)(\/[1-9][0-9]?)?)(,([*]|([0-2]?[0-9]|3[0-1])([-]([0-2]?[0-9]|3[0-1]))?)(\/[1-9][0-9]?)?)*$/ {if(bad) print > bad; next}
# month
# Ranges or lists of names are not allowed
$4!~/^[A-Za-z0-9*,\/-]{1,32}$/ {if(bad) print > bad; next}
toupper($4)!~/^((JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)|(([*]|([0]?[0-9]|1[0-2])([-]([0]?[0-9]|1[0-2]))?)(\/[1-9][0-9]?)?)(,([*]|([0]?[0-9]|1[0-2])([-]([0]?[0-9]|1[0-2]))?)(\/[1-9][0-9]?)?)*)$/ {if(bad) print > bad; next}
# day of week
# Ranges or lists of names are not allowed
$5!~/^[A-Za-z0-9*,\/-]{1,32}$/ {if(bad) print > bad; next}
#toupper($5)!~/^([*]|[0]?[0-7])$/ {if(bad) print > bad; next}
toupper($5)!~/^((MON|TUE|WED|THU|FRI|SAT|SUN)|(([*]|[0]?[0-7]([-][0]?[0-7])?)(\/[1-9][0-9]?)?)(,([*]|[0]?[0-7]([-][0]?[0-7])?)(\/[1-9][0-9]?)?)*)$/ {if(bad) print > bad; next}
# root
/^([A-Za-z0-9*,\/-]{1,32}\s+){5}\/root\/([A-Za-z0-9\/_+-])*[A-Za-z0-9._+-]*\s*$/ {print; next}
/^([A-Za-z0-9*,\/-]{1,32}\s+){5}su martem -c '[A-Za-z0-9@.:;\/" _>+-]*'\s*$/     {print; next}
# other
{if(nomatch) print > nomatch}
