#!/bin/sh
###############################################################################
#                                                                             #
#                            Update system files                              #
#                                                                             #
# - $1 location of this script                                                #
# - $2 log file location                                                      #
#                                                                             #
###############################################################################
U_LOG="$2"
E_LOG="$3"
if [ "${U_LOG}" = "" ]; then
    U_LOG='/tmp/res.txt'
fi
if [ "${E_LOG}" = "" ]; then
    E_LOG='/tmp/err.txt'
fi
export UPD_ROOT="$1"
export ERR_LOG="${E_LOG}"

logg()
{
    echo -e "$(date) - $1" | tee -a "${UPD_LOG}"
}



DIRNAME="busybox dirname"
AWK="busybox awk"
TR="busybox tr"
CUT="busybox cut"
SED="busybox sed"
SHA512SUM="busybox sha512sum"



###############################################################################
#                                                                             #
#                                The Script                                   #
#                                                                             #
###############################################################################


# locate GWUPD directory
GWUPD_DIR="$(${DIRNAME} "${U_LOG}")"
DONE_DIR="$(cd "${GWUPD_DIR}/.."; echo "$(pwd)")"

DONE_FILE="${DONE_DIR}/done"

#SUM_CMD=md5sum
SUM_CMD="${SHA512SUM}"


heading()
{
    echo -e "\n##\n#\t$1\n#" >> "${DEBUG}"
}

IsUpdateDone()
{
    grep -q -- "${1}" "${DONE_FILE}"
}

SD_CARD='/mnt/sd'
isSDmounted()
{
    grep -q -- "mmcblk.p1.*${SD_CARD}" '/proc/mounts'
}

backup_fw() {
    # skip if gwupd-bkp does not exist
    [ -d "${SD_CARD}/gwupd-bkp" ] || return 0
    [ -d "${GWUPD_DIR}"         ] || return 0
    logg "Start firmware backup"
    # skip if update was done from SD card
    if [ "${GWUPD_DIR}" == "${SD_CARD}/gwupd" ]; then
        logg "No need to backup: updated from SD card"
        return 0
    fi
    # skip if checksums match
    if diff -q "${SD_CARD}/gwupd/md5sums" "${GWUPD_DIR}/md5sums"; then
        logg "No need to backup: checksums match"
        return 0
    fi
    # rotate
    rm -r "${SD_CARD}/gwupd-bkp/gwupd.4" 2>/dev/null
    mv    "${SD_CARD}/gwupd-bkp/gwupd.3" "${SD_CARD}/gwupd-bkp/gwupd.4" 2>/dev/null
    mv    "${SD_CARD}/gwupd-bkp/gwupd.2" "${SD_CARD}/gwupd-bkp/gwupd.3" 2>/dev/null
    mv    "${SD_CARD}/gwupd-bkp/gwupd.1" "${SD_CARD}/gwupd-bkp/gwupd.2" 2>/dev/null
    mv    "${SD_CARD}/gwupd-bkp/gwupd.0" "${SD_CARD}/gwupd-bkp/gwupd.1" 2>/dev/null
    mv    "${SD_CARD}/gwupd"             "${SD_CARD}/gwupd-bkp/gwupd.0" 2>/dev/null
    # copy
    cp -r "${GWUPD_DIR}" "${SD_CARD}/gwupd"
    # avoid redoing update
    echo "${DONE_STRING}" >> "${SD_CARD}/done"
    logg "Done firmware backup"
}

UPD_HASH="$(${AWK} '/upd\./{print $1}' "${GWUPD_DIR}/md5sums")"

MAC_ADDR="$(cat '/sys/class/net/eth0/address')"
DONE_STRING="$(echo "${UPD_HASH}-${MAC_ADDR}" | ${SUM_CMD} | ${AWK} '{print $1}')"

DEBUG_DIR="${SD_CARD}/$(echo "${MAC_ADDR}" | ${SED} 's/://g' | ${CUT} -b5-12)/"

DEBUG="${DEBUG_DIR}/INFO"

if isSDmounted; then
    mkdir -p "${DEBUG_DIR}"
    export UPD_LOG="${DEBUG_DIR}/res.txt"
else
    export UPD_LOG="${U_LOG}"
fi

echo "Log continues in file: ${UPD_LOG}" >> "${U_LOG}"

logg "Checking if update is applied."

# rm -f /usr/bin/prototype

if IsUpdateDone "${DONE_STRING}"; then
    logg "Update is already applied."
else
    # update not done

    if [ -d "${GWUPD_DIR}_done" ]; then
        logg "Removing old update folder."
        rm -rf "${GWUPD_DIR}_done"
    fi

    logg "Starting update to $(cat "${UPD_ROOT}/VERSION"), $(cat "${UPD_ROOT}/PACKED")"

    if isSDmounted; then

        logg "Writing info to SD-card"

        heading "MAC address"
        echo "${MAC_ADDR}" >> "${DEBUG}"

        heading "Current time"
        date >> "${DEBUG}"

        heading "Disk free space"
        df -h >> "${DEBUG}"

        heading "Network interfaces"
        ifconfig >> "${DEBUG}"

        heading "Memory info"
        cat '/proc/meminfo' >> "${DEBUG}"

        heading "List of currently running processes"
        ps aux >> "${DEBUG}"

        logg "Syncing filesystem"
        sync
    fi

    ! rm '/var/run/telem/post_update_done'

    logg "Starting UpdateSystem.sh"
    "${UPD_ROOT}"/UpdateSystem.sh
    #if [ "$?" = "0" ]; then
    logg "Writing done '${DONE_STRING}' to '${DONE_FILE}'"
    echo "${DONE_STRING}" >> "${DONE_FILE}"
    #fi

    chmod a+r "${UPD_LOG}"

    logg "Update script finished."

    if isSDmounted; then
        backup_fw
    fi
fi

# finalize
if [ "${GWUPD_DIR}" != "/mnt/sd/gwupd" ]; then
    mv "${GWUPD_DIR}" "${GWUPD_DIR}_done"
    chmod a+r "${GWUPD_DIR}_done"/*
    # remove update file to save space
    rm -f     "${GWUPD_DIR}_done"/upd.*
fi

sync

if isSDmounted; then
    umount -l "${SD_CARD}"
fi

