echo "****************************************************"
echo "****************************************************"
echo ""
echo "AQ250 Flashing Script - 30/08/2016"
echo ""



STARTTIME=$(date +%s)

##---------Start of variables---------------------##

## Set Server IP here
SERVER_IP=$1

## Names of the images to grab from TFTP server
BOOT_PARTITION="boot_partition.tar.gz"

## Rename rootfs as needed depending on use of tar or img
ROOTFS_PARTITION="rootfs_partition.tar.gz"

## Declare eMMC device name here
DRIVE="/dev/mmcblk0"

##----------End of variables-----------------------##



do_partitions=true
do_flasher=true
do_linux=true
do_rootfs=true

if grep -q ${DRIVE}p /proc/mounts; then
  partitions=$(grep ${DRIVE}p /proc/mounts | awk '{print $2}')
  counter=0
  for i in $partitions; do \
	  counter=$((counter+1));
  done
  if [ $counter -eq 3 ]; then
	echo "Partitioning not needed."
	do_partitions=false
  fi
fi

if diff /media/card/boot/zImage /media/mmcblk0p2/boot/zImage >/dev/null ; then
	if diff /media/card/boot/am335x-aq250.dtb /media/mmcblk0p2/boot/am335x-aq250.dtb >/dev/null ; then
		echo "Flasher update not needed."
		do_flasher=false
	fi
fi

tftp -g -r hash.txt ${SERVER_IP}
if diff hash.txt /media/mmcblk0p3/boot/hash.txt >/dev/null ; then
	echo "rootfs download not needed."
	do_rootfs=false
	cp /media/mmcblk0p3/boot/${ROOTFS_PARTITION} .
fi



## TFTP files from host.  Edit the files and host IP address for your application.
## We are grabbing two files, one an archive with files to populate a FAT partion,
## which we will create.  Another for a filesystem image to 'dd' onto an unmounted partition.
## Using a compressed tarball can be easier to implement, however, with a large file system
## with a lot of small files, we recommend a 'dd' image of the partition to speed up writes.
echo "Getting files from server: ${SERVER_IP}"
if $do_flasher; then
timeout -t 300 tftp -g -r ${BOOT_PARTITION} ${SERVER_IP} &
boot_pid=$!
fi
if $do_rootfs; then
timeout -t 300 tftp -g -r ${ROOTFS_PARTITION} ${SERVER_IP} &
rootfs_pid=$!
fi
timeout -t 300 tftp -g -r arcteq.tar.gz ${SERVER_IP} &
arcteq_pid=$!



## PARTITIONING PART
if $do_partitions; then

## Kill any partition info that might be there
dd if=/dev/zero of=$DRIVE bs=4k count=1
sync
sync

## Figure out how big the eMMC is in bytes
SIZE=`fdisk -l $DRIVE | grep Disk | awk '{print $5}'`

## Translate size into segments, which traditional tools call Cylinders. eMMC is not a spinning disk.
## We are basically ignoring what FDISK and SFDISK are reporting because it is not really accurate.
## we are translating this info to something that makes more sense for eMMC.
CYLINDERS=`echo $SIZE/255/63/512 | bc`

## Check to see if the eMMC partitions have automatically loaded from the old MBR.
## This might have occured during the boot process if the kernel detected a filesystem
## before we killed the MBR. We will need to unmount and kill them by writing 4k zeros to the
## partitions that were found.

check_mounted(){
  is_mounted=$(grep ${DRIVE}p /proc/mounts | awk '{print $2}')

  if grep -q ${DRIVE}p /proc/mounts; then
      echo "Found mounted partition(s) on " ${DRIVE}": " $is_mounted
      umount $is_mounted
      counter=1
      for i in $is_mounted; do \
          echo "4k erase on ${DRIVE}p${counter}"; 
          dd if=/dev/zero of=${DRIVE}p${counter} bs=4k count=1;
          counter=$((counter+1));
      done
  else
      echo "No partition found. Continuing."
  fi
}

check_mounted;

## Partitioning the eMMC using information gathered.
## Here is where you can add/remove partitions.
## We are building 3 partitions:
##  1. FAT, size = 4 cylinders * 255 heads * 63 sectors * 512 bytes/sec = ~32MB
##  2. FAT, size = 4 cylinders * 255 heads * 63 sectors * 512 bytes/sec = ~32MB
##  3. EXT3, size = 467 ($CYLINDERS-[4 for fat]) cylinders * 255 heads * 63 sectors * 512 bytes/sec = ~4GB
##
## You will need to change the lines ",9,0c0C,*", "10,,,-" to suit your needs.  Adding is similar,
## but you will need to be aware of partition sizes and boundaries.  Use the man page for sfdisk.
echo "Partitioning the eMMC..."
sfdisk -D -H 255 -S 63 -C $CYLINDERS $DRIVE << EOF
0,4,0x0C,-
4,4,0x0C,-
8,,,-
EOF

## This sleep is necessary as there is a service which attempts
## to automount any filesystems that it finds as soon as sfdisk
## finishes partitioning.  We sleep to let it run.  May need to
## be lengthened if you have more partitions.
sleep 2

## Check here if there has been a partition that automounted.
##  This will eliminate the old partition that gets
##  automatically found after the sfdisk command.  It ONLY
##  gets found if there was a previous file system on the same
##  partition boundary.  Happens when running this script more than once.
##  To fix, we just unmount and write some zeros to it.
check_mounted;

## END PARTITIONING PART
fi



## FLASHER PART
if $do_flasher; then

## Wait for boot to finish tftp
wait $boot_pid
if [ ! -f ${BOOT_PARTITION} ]; then
	echo "TFTP error flasher file not received."
	exit 1
fi

umount /media/card
umount /media/mmcblk0p2

## Clean up the dos (FAT) partitions as recommended by SFDISK
## Make sure posted writes are cleaned up
dd if=/dev/zero of=${DRIVE}p1 bs=512 count=1
sync
sync
dd if=/dev/zero of=${DRIVE}p2 bs=512 count=1
sync
sync

## Format the eMMC into 3 partitions
echo "Formatting the eMMC into 3 partitions..."

## Format the boot partition to fat32
mkfs.vfat -F 32 -n "flasher1" ${DRIVE}p1
mkfs.vfat -F 32 -n "flasher2" ${DRIVE}p2

## Make sure posted writes are cleaned up
sync
sync
echo "Formatting done."

## Make temp directories for mountpoints
mkdir tmp_flasher1
mkdir tmp_flasher2

## Mount partitions for tarball extraction. NOT for 'dd'.
mount -t vfat ${DRIVE}p1 tmp_flasher1
mount -t vfat ${DRIVE}p2 tmp_flasher2

echo "Copying Files..."
time tar -xf ${BOOT_PARTITION} -C tmp_flasher1
sync
sync
umount tmp_flasher1
time tar -xf ${BOOT_PARTITION} -C tmp_flasher2
sync
sync
umount tmp_flasher2
rmdir tmp_*
echo "Boot partitions done."

## END FLASHER PART
fi



## LINUX PART
if $do_linux; then

## Wait for rootfs to finish tftp
if $do_rootfs; then
wait $rootfs_pid
fi
wait $arcteq_pid
if [ ! -f ${ROOTFS_PARTITION} ]; then
	echo "TFTP error rootfs file not received."
	exit 1
fi
if [ ! -f arcteq.tar.gz ]; then
	echo "TFTP error arcteq file not received."
	exit 1
fi
tftp -g -r the_end.txt ${SERVER_IP}

umount /media/mmcblk0p3

## Format the rootfs to ext3 (or ext4, etc.) if using a tar file.
## We DO NOT need to format this partition if we are 'dd'ing an image
## Comment out this line if using 'dd' of an image.
mkfs.ext3 -L "rootfs" ${DRIVE}p3

## Make sure posted writes are cleaned up
sync
sync
echo "Formatting done."

## Comment this line out if using 'dd' of an image. It is not needed.
mkdir tmp_rootfs

## If 'dd'ing the rootfs, there is no need to mount it. Comment out the below.
mount -t ext3 ${DRIVE}p3 tmp_rootfs

## If using a tar archive, untar it with the below.
## If using 'dd' of an img, comment these lines out and use the below.
time tar -xf ${ROOTFS_PARTITION} -C tmp_rootfs
sync
sync
time tar -xf arcteq.tar.gz -C tmp_rootfs
sync
sync
cp hash.txt tmp_rootfs/boot/
cp ${ROOTFS_PARTITION} tmp_rootfs/boot/
umount tmp_rootfs
rmdir tmp_*

## END LINUX PART
fi



IP=$(fw_printenv -n ipaddr_new)
if [ ! "${IP}" == "" ]; then
	fw_setenv ipaddr_back $IP
fi
SERVER=$(fw_printenv -n serverip_new)
if [ ! "${SERVER}" == "" ]; then
	fw_setenv serverip_back $SERVER
fi
GATEWAY=$(fw_printenv -n gatewayip_new)
if [ ! "${GATEWAY}" == "" ]; then
	fw_setenv gatewayip_back $GATEWAY
fi
NETMASK=$(fw_printenv -n netmask_new)
if [ ! "${NETMASK}" == "" ]; then
	fw_setenv netmask_back $NETMASK
fi



ENDTIME=$(date +%s)
echo "It took $(($ENDTIME - $STARTTIME)) seconds to complete this task..."
## Reboot
echo ""
echo "********************************************"
echo "AQ250 Flashing Script is complete."
echo ""
